package com.ElyStudio.leGaou.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.models.Invitee;
import com.ElyStudio.leGaou.utilities.Constants;
import com.squareup.picasso.Picasso;

import java.util.List;

public class InviteeAdapter extends RecyclerView.Adapter<InviteeAdapter.InviteeViewHolder> {

    private final Context context;
    private final List<Invitee> inviteeList;
    private final int inviteeJoinReward;

    public InviteeAdapter(Context context, List<Invitee> inviteeList, int inviteeJoinReward) {
        this.context = context;
        this.inviteeList = inviteeList;
        this.inviteeJoinReward = inviteeJoinReward;
    }

    @NonNull
    @Override
    public InviteeAdapter.InviteeViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new InviteeViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.user_invitee_layout, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull InviteeAdapter.InviteeViewHolder holder, int position) {
        Invitee invitee = inviteeList.get(position);

        if(invitee.getAvatar().trim().equals(""))
        {
            holder.inviteeAvatar.setImageDrawable(ContextCompat.getDrawable(context,R.drawable.image_placeholder));
        }
        else
        {
            Picasso.get().load(Constants.ADMIN_PANEL_URL+invitee.getAvatar()).into(holder.inviteeAvatar);
        }

        holder.inviteeName.setText(invitee.getName());
        String inviteeEmail = invitee.getEmail().substring(0,4)+"*****";
        holder.inviteeEmail.setText(inviteeEmail);
        String inviteeJoinBonus = "+"+inviteeJoinReward;
        holder.inviteeBonus.setText(inviteeJoinBonus);

    }

    @Override
    public int getItemCount() {
        if (inviteeList != null)
        return inviteeList.size();
        else
            return 0;
    }

    public static class InviteeViewHolder extends RecyclerView.ViewHolder {
        ImageView inviteeAvatar;
        TextView inviteeName,inviteeEmail,inviteeBonus;
        public InviteeViewHolder(@NonNull View itemView) {
            super(itemView);

            inviteeAvatar = itemView.findViewById(R.id.inviteeAvatar);
            inviteeName = itemView.findViewById(R.id.inviteeName);
            inviteeEmail = itemView.findViewById(R.id.inviteeEmail);
            inviteeBonus = itemView.findViewById(R.id.inviteeBonus);

        }
    }
}
